package com.biz.crm.dms.business.interaction.local.entity.complaint;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 投诉回复文件实体类
 *
 * @author ning.zhang
 * @date 2021/11/24
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ComplaintEntity", description = "投诉回复文件实体类")
@Entity
@TableName("dms_complaint_reply_file")
@Table(name = "dms_complaint_reply_file", indexes = {
    @Index(name = "dms_complaint_index1", columnList = "tenant_code"),
    @Index(name = "dms_complaint_index2", columnList = "reply_id"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_complaint_reply_file", comment = "投诉回复文件表")
public class ComplaintReplyFileEntity extends TenantEntity {

  private static final long serialVersionUID = -6505555324575913438L;

  /**
   * 投诉回复id
   */
  @ApiModelProperty("投诉回复id")
  @Column(name = "reply_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '投诉回复id'")
  private String replyId;


  /**
   * 文件显示顺序
   */
  @ApiModelProperty("文件显示顺序")
  @Column(name = "sort_num", length = 5, columnDefinition = "int(5) COMMENT '文件显示顺序'")
  private Integer sortNum;

  /**
   * 文件路径
   */
  @ApiModelProperty("文件路径")
  @Column(name = "file_url", columnDefinition = "VARCHAR(255) COMMENT '文件路径'")
  private String fileUrl;

  /**
   * 文件名称
   */
  @ApiModelProperty("文件名称")
  @Column(name = "file_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '文件名称'")
  private String fileName;
}
