package com.biz.crm.dms.business.interaction.local.entity.information;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 公告文件实体类
 *
 * @author ning.zhang
 * @date 2021/11/22
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompanyInformationFileEntity", description = "公司资料文件实体类")
@Entity
@TableName("dms_company_information_file")
@Table(name = "dms_company_information_file", indexes = {
    @Index(name = "dms_notice_file_index1", columnList = "information_id"),
    @Index(name = "dms_notice_file_index2", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_company_information_file", comment = "公司资料文件表")
public class CompanyInformationFileEntity extends TenantEntity {

  private static final long serialVersionUID = -7915829750094346037L;

  /**
   * 公司资料id
   */
  @ApiModelProperty("公司资料id")
  @Column(name = "information_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '公司资料id'")
  private String informationId;


  /**
   * 文件显示顺序
   */
  @ApiModelProperty("文件显示顺序")
  @Column(name = "sort_num", length = 5, columnDefinition = "int(5) COMMENT '文件显示顺序'")
  private Integer sortNum;

  /**
   * 文件路径
   */
  @ApiModelProperty("文件路径")
  @Column(name = "file_url", columnDefinition = "VARCHAR(255) COMMENT '文件路径'")
  private String fileUrl;

  /**
   * 文件名称
   */
  @ApiModelProperty("文件名称")
  @Column(name = "file_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '文件名称'")
  private String fileName;

  /** 文件唯一标识 */
  @ApiModelProperty(name = "objectName", value = "文件唯一标识", required = true)
  @Column(
      name = "object_name",
      length = 200,
      columnDefinition = "VARCHAR(200) NOT NULL COMMENT '文件唯一标识'")
  private String objectName;

  /** 文件全路径 */
  @ApiModelProperty(name = "url", value = "文件全路径", required = true)
  @Column(name = "url", length = 200, columnDefinition = "VARCHAR(200) NOT NULL COMMENT '文件全路径'")
  private String url;

  /** 文件路径 */
  @ApiModelProperty(name = "urlPath", value = "文件路径", required = true)
  @Column(
      name = "url_path",
      length = 200,
      columnDefinition = "VARCHAR(200) NOT NULL COMMENT '文件路径'")
  private String urlPath;

  /** 域名 */
  @ApiModelProperty(name = "urlPathPrefix", value = "域名", required = true)
  @Column(
      name = "url_path_prefix",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '域名'")
  private String urlPathPrefix;
}
