package com.biz.crm.dms.business.interaction.local.entity.notice;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 公告文件实体类
 *
 * @author ning.zhang
 * @date 2021/11/22
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeFileEntity", description = "公告文件实体类")
@Entity
@TableName("dms_notice_file")
@Table(name = "dms_notice_file", indexes = {
    @Index(name = "dms_notice_file_index1", columnList = "notice_id"),
    @Index(name = "dms_notice_file_index2", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_notice_file", comment = "公告文件表")
public class NoticeFileEntity extends TenantEntity {

  private static final long serialVersionUID = -7915829750094346037L;

  /**
   * 公告id
   */
  @ApiModelProperty("公告id")
  @Column(name = "notice_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '公告id'")
  private String noticeId;


  /**
   * 文件显示顺序
   */
  @ApiModelProperty("文件显示顺序")
  @Column(name = "sort_num", length = 5, columnDefinition = "int(5) COMMENT '文件显示顺序'")
  private Integer sortNum;

  /**
   * 文件路径
   */
  @ApiModelProperty("文件路径")
  @Column(name = "file_url", columnDefinition = "VARCHAR(255) COMMENT '文件路径'")
  private String fileUrl;

  /**
   * 文件名称
   */
  @ApiModelProperty("文件名称")
  @Column(name = "file_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '文件名称'")
  private String fileName;


  /**
   * 目标文件
   */
  @ApiModelProperty("目标文件")
  @Column(name = "object_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '目标文件'")
  private String objectName;
}
