package com.biz.crm.dms.business.interaction.local.entity.notice;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * 公告阅读记录实体类
 *
 * @author ning.zhang
 * @date 2021/11/30
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "NoticeReadRecordEntity", description = "公告阅读记录实体类")
@Entity
@TableName("dms_notice_read_record")
@Table(name = "dms_notice_read_record", indexes = {
    @Index(name = "dms_notice_index1", columnList = "notice_id,customer_code", unique = true),
    @Index(name = "dms_notice_index2", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_notice_read_record", comment = "公告阅读记录表")
public class NoticeReadRecordEntity extends TenantOpEntity {

  private static final long serialVersionUID = -1387808840525275563L;

  /**
   * 公告id
   */
  @ApiModelProperty("公告id")
  @Column(name = "notice_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '公告id'")
  private String noticeId;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;
}
