package com.biz.crm.dms.business.interaction.local.mapper.information;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationEntity;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationPageDto;
import org.apache.ibatis.annotations.Param;

/**
 * 公司资料表的mybatis-plus接口类 {@link CompanyInformationEntity}
 *
 * @author ning.zhang
 * @date 2021-11-24 13:34:46
 */
public interface CompanyInformationMapper extends BaseMapper<CompanyInformationEntity> {

  /**
   * 公司资料分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<CompanyInformationEntity> findByConditions(Page<CompanyInformationEntity> page, @Param("dto") CompanyInformationPageDto dto);

  /**
   * 客户-公司资料分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<CompanyInformationEntity> findByCompanyInformationCustomerPageDto(Page<CompanyInformationEntity> page, @Param("dto") CompanyInformationCustomerPageDto dto);

  /**
   * 通过ID获取公司资料信息
   *
   * @param id 公司资料ID
   * @return 公司资料信息
   */
  CompanyInformationEntity findById(@Param("id") String id);
}

