package com.biz.crm.dms.business.interaction.local.repository.information;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationEntity;
import com.biz.crm.dms.business.interaction.local.mapper.information.CompanyInformationMapper;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationPageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公司资料表的数据库访问类 {@link CompanyInformationEntity}
 *
 * @author ning.zhang
 * @date 2021-11-24 13:34:46
 */
@Component
public class CompanyInformationRepository extends ServiceImpl<CompanyInformationMapper, CompanyInformationEntity> {

  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(CompanyInformationEntity::getId, ids)
        .set(CompanyInformationEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param ids          ID集合
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(CompanyInformationEntity::getId, ids)
        .set(CompanyInformationEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 公司资料分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CompanyInformationEntity>公司资料分页信息
   */
  public Page<CompanyInformationEntity> findByConditions(Pageable pageable, CompanyInformationPageDto dto) {
    Page<CompanyInformationEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 客户-公司资料分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CompanyInformationEntity>公司资料分页信息
   */
  public Page<CompanyInformationEntity> findByCompanyInformationCustomerPageDto(Pageable pageable, CompanyInformationCustomerPageDto dto) {
    Page<CompanyInformationEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByCompanyInformationCustomerPageDto(page, dto);
  }

  /**
   * 通过ID获取公司资料信息
   *
   * @param id 公司资料ID
   * @return 公司资料信息
   */
  public CompanyInformationEntity findById(String id) {
    return this.baseMapper.findById(id);
  }
}
