package com.biz.crm.dms.business.interaction.local.repository.notice;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeFileEntity;
import com.biz.crm.dms.business.interaction.local.mapper.notice.NoticeFileMapper;
import org.springframework.stereotype.Component;

/**
 * 公告文件表的数据库访问类 {@link NoticeFileEntity}
 *
 * @author ning.zhang
 * @date 2021-11-22 16:13:46
 */
@Component
public class NoticeFileRepository extends ServiceImpl<NoticeFileMapper, NoticeFileEntity> {

  /**
   * 通过公告ID删除公告文件信息
   *
   * @param noticeId 公告ID
   */
  public void deleteByNoticeId(String noticeId) {
    this.lambdaUpdate()
        .eq(NoticeFileEntity::getNoticeId, noticeId)
        .remove();
  }

}
