package com.biz.crm.dms.business.interaction.local.repository.notice;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeScopeEntity;
import com.biz.crm.dms.business.interaction.local.mapper.notice.NoticeChannelScopeMapper;
import org.springframework.stereotype.Component;

/**
 * 公告渠道范围表的数据库访问类 {@link NoticeScopeEntity}
 *
 * @author ning.zhang
 * @date 2021-11-22 16:12:29
 */
@Component
public class NoticeScopeRepository extends ServiceImpl<NoticeChannelScopeMapper, NoticeScopeEntity> {

  /**
   * 通过公告ID删除公告范围信息
   *
   * @param noticeId 公告ID
   */
  public void deleteByNoticeId(String noticeId) {
    this.lambdaUpdate()
        .eq(NoticeScopeEntity::getNoticeId, noticeId)
        .remove();
  }
}
