package com.biz.crm.dms.business.interaction.local.service.carouselPicture.internal;

import com.biz.crm.dms.business.interaction.local.entity.carouselPicture.CarouselPictureScopeEntity;
import com.biz.crm.dms.business.interaction.local.repository.carouselPicture.CarouselPictureScopeRepository;
import com.biz.crm.dms.business.interaction.local.service.carouselPicture.CarouselPictureScopeService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.ScopeDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class CarouselPictureScopeServiceImpl implements CarouselPictureScopeService {
  @Autowired(required = false)
  CarouselPictureScopeRepository carouselPictureScopeRepository;

  @Autowired(required = false)
  NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(List<ScopeDto> scopeDtoList, String pictureId) {
    Validate.notBlank(pictureId, "图片id不能为空");
    carouselPictureScopeRepository.deleteByPictureId(pictureId);
    if (CollectionUtils.isEmpty(scopeDtoList)) {
      return;
    }
    String tenantCode = TenantUtils.getTenantCode();

    List<CarouselPictureScopeEntity> entities = scopeDtoList.stream()
        .filter(dto -> Objects.nonNull(dto)
            && StringUtils.isNotBlank(dto.getScopeCode())
            && StringUtils.isNotBlank(dto.getScopeType()))
        .map(dto -> {
          CarouselPictureScopeEntity entity = nebulaToolkitService.copyObjectByWhiteList(dto, CarouselPictureScopeEntity.class, HashSet.class, ArrayList.class);
          entity.setPictureId(pictureId);
          entity.setTenantCode(tenantCode);
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)){
      return;
    }
    carouselPictureScopeRepository.saveBatch(entities);
  }
}
