package com.biz.crm.dms.business.interaction.local.service.carouselPicture.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.interaction.local.constant.CarouselPictureConstant;
import com.biz.crm.dms.business.interaction.local.entity.carouselPicture.CarouselPictureEntity;
import com.biz.crm.dms.business.interaction.local.repository.carouselPicture.CarouselPictureRepository;
import com.biz.crm.dms.business.interaction.local.repository.carouselPicture.CarouselPictureVoRepository;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPicturePageDto;
import com.biz.crm.dms.business.interaction.sdk.service.carouselPicture.CarouselPictureVoService;
import com.biz.crm.dms.business.interaction.sdk.vo.carouselPicture.CarouselPictureVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

@Service
public class CarouselPictureVoServiceImpl implements CarouselPictureVoService {
  @Autowired(required = false)
  CarouselPictureRepository carouselPictureRepository;

  @Autowired(required = false)
  CarouselPictureVoRepository carouselPictureVoRepository;

  @Autowired(required = false)
  NebulaToolkitService nebulaToolkitService;

  @Override
  public CarouselPictureVo findById(String id) {
    if (StringUtils.isEmpty(id)) return null;
    CarouselPictureEntity entity = carouselPictureRepository.findById(id);
    Validate.isTrue(Objects.nonNull(entity), "该图片不存在！");
    CarouselPictureVo vo = nebulaToolkitService.copyObjectByBlankList(entity, CarouselPictureVo.class, HashSet.class, ArrayList.class);

    //TODO 通过客户编码查找客户名称
    return vo;
  }

  @Override
  public Page<CarouselPictureVo> findByConditions(Pageable pageable, CarouselPicturePageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new CarouselPicturePageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    Page<CarouselPictureVo> entity = carouselPictureVoRepository.findByConditions(pageable, dto);
    List<CarouselPictureVo> records = entity.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return null;
    }
    Page<CarouselPictureVo> vo = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Date now = new Date();
    records.forEach(e -> {
      if (e.getStartTime().after(now)) {
        e.setEffectiveTime(CarouselPictureConstant.EFFECTIVE_TIME_NOT_START);
      }
      if (!e.getStartTime().after(now) && !e.getEndTime().before(now)) {
        e.setEffectiveTime(CarouselPictureConstant.EFFECTIVE_TIME_START);
      }
      if (e.getEndTime().before(now)) {
        e.setEffectiveTime(CarouselPictureConstant.EFFECTIVE_TIME_END);
      }
    });
    vo.setRecords(records);
    return vo;
  }
}
