package com.biz.crm.dms.business.interaction.local.service.complaint.internal;

import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintFileEntity;
import com.biz.crm.dms.business.interaction.local.repository.complaint.ComplaintFileRepository;
import com.biz.crm.dms.business.interaction.local.service.complaint.ComplaintFileService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.FileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 投诉文件表服务实现类
 *
 * @author ning.zhang
 * @date 2021-11-24 16:39:33
 */
@Slf4j
@Service("complaintFileService")
public class ComplaintFileServiceImpl implements ComplaintFileService {

  @Autowired(required = false)
  private ComplaintFileRepository complaintFileRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void create(List<FileDto> dtoList, String complaintId) {
    Validate.notBlank(complaintId, "投诉ID不能为空");
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    String tenantCode = TenantUtils.getTenantCode();
    //过滤无效的数据
    List<ComplaintFileEntity> entities = dtoList.stream()
        .filter(Objects::nonNull)
        .map(dto -> {
          ComplaintFileEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(dto, ComplaintFileEntity.class, HashSet.class, ArrayList.class);
          entity.setComplaintId(complaintId);
          entity.setTenantCode(tenantCode);
          entity.setSortNum(dtoList.indexOf(dto));
          entity.setFileUrl(dto.getUrl());
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    this.complaintFileRepository.saveBatch(entities);
  }
}
