package com.biz.crm.dms.business.interaction.local.service.complaint.internal;

import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintEntity;
import com.biz.crm.dms.business.interaction.local.repository.complaint.ComplaintRepository;
import com.biz.crm.dms.business.interaction.sdk.service.complaint.ComplaintVoService;
import com.biz.crm.dms.business.interaction.sdk.vo.complaint.ComplaintCustomerVo;
import com.biz.crm.dms.business.interaction.sdk.vo.complaint.ComplaintVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * 投诉Vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2021/11/25
 */
@Service
public class ComplaintVoServiceImpl implements ComplaintVoService {

  @Autowired(required = false)
  private ComplaintRepository complaintRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private CustomerVoService customerVoService;

  @Override
  public ComplaintVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    ComplaintEntity entity = this.complaintRepository.findById(id);
    if (Objects.isNull(entity)) {
      return null;
    }
    ComplaintVo complaintVo = this.nebulaToolkitService.copyObjectByBlankList(entity, ComplaintVo.class, HashSet.class, ArrayList.class);
    CustomerVo customerVo = customerVoService.findDetailsByIdOrCode(null, complaintVo.getCustomerCode());
    if (Objects.nonNull(customerVo)) {
      ComplaintCustomerVo complaintCustomerVo = this.nebulaToolkitService.copyObjectByBlankList(customerVo, ComplaintCustomerVo.class, HashSet.class, ArrayList.class);
      complaintVo.setComplaintCustomer(complaintCustomerVo);
    }
    return complaintVo;
  }
}
