package com.biz.crm.dms.business.interaction.local.service.information;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationEntity;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationDto;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationPageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 公司资料表服务接口
 *
 * @author ning.zhang
 * @date 2021-11-24 13:34:46
 */
public interface CompanyInformationService {

  /**
   * 创建公司资料
   *
   * @param dto 参数dto
   * @return 创建的公司资料
   */
  CompanyInformationEntity create(CompanyInformationDto dto);

  /**
   * 更新公司资料
   *
   * @param dto 参数dto
   * @return 更新的公司资料
   */
  CompanyInformationEntity update(CompanyInformationDto dto);

  /**
   * 批量删除公司资料
   *
   * @param ids 公司资料id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用公司资料
   *
   * @param ids 公司资料id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用公司资料
   *
   * @param ids 公司资料id集合
   */
  void disableBatch(List<String> ids);

  /**
   * 公司资料分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CompanyInformationEntity>公司资料分页信息
   */
  Page<CompanyInformationEntity> findByConditions(Pageable pageable, CompanyInformationPageDto dto);

  /**
   * 客户-公司资料分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CompanyInformationEntity>公司资料分页信息
   */
  Page<CompanyInformationEntity> findByCompanyInformationCustomerPageDto(Pageable pageable, CompanyInformationCustomerPageDto dto);
}
