package com.biz.crm.dms.business.interaction.local.service.information.internal;

import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationScopeEntity;
import com.biz.crm.dms.business.interaction.local.repository.information.CompanyInformationScopeRepository;
import com.biz.crm.dms.business.interaction.local.service.information.CompanyInformationScopeService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.ScopeDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 公司资料范围表服务实现类
 *
 * @author ning.zhang
 * @date 2021-11-24 13:35:44
 */
@Slf4j
@Service("companyInformationScopeService")
public class CompanyInformationScopeServiceImpl implements CompanyInformationScopeService {

  @Autowired(required = false)
  private CompanyInformationScopeRepository companyInformationScopeRepository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(List<ScopeDto> dtoList, String informationId) {
    Validate.notBlank(informationId, "公司资料ID不能为空");
    this.companyInformationScopeRepository.deleteByInformationId(informationId);
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    String tenantCode = TenantUtils.getTenantCode();
    //过滤无效的数据
    List<CompanyInformationScopeEntity> entities = dtoList.stream()
        .filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty(dto.getScopeCode()) && StringUtils.isNotEmpty(dto.getScopeType()))
        .map(dto -> {
          CompanyInformationScopeEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(dto, CompanyInformationScopeEntity.class, HashSet.class, ArrayList.class);
          entity.setInformationId(informationId);
          entity.setTenantCode(tenantCode);
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    this.companyInformationScopeRepository.saveBatch(entities);
  }
}
