package com.biz.crm.dms.business.interaction.local.service.information.internal;

import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationEntity;
import com.biz.crm.dms.business.interaction.local.repository.information.CompanyInformationRepository;
import com.biz.crm.dms.business.interaction.local.service.base.AbstractRelationDataService;
import com.biz.crm.dms.business.interaction.sdk.service.information.CompanyInformationVoService;
import com.biz.crm.dms.business.interaction.sdk.vo.information.CompanyInformationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * 公司资料VO服务接口实现类
 *
 * @author ning.zhang
 * @date 2021/11/24
 */
@Service
public class CompanyInformationVoServiceImpl extends AbstractRelationDataService implements CompanyInformationVoService {

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private CompanyInformationRepository companyInformationRepository;

  @Override
  public CompanyInformationVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    CompanyInformationEntity entity = this.companyInformationRepository.findById(id);
    if (Objects.isNull(entity)) {
      return null;
    }
    CompanyInformationVo companyInformationVo = this.nebulaToolkitService.copyObjectByBlankList(entity, CompanyInformationVo.class, HashSet.class, ArrayList.class);
    this.perfectScopeInfo(companyInformationVo.getScopeList());
    return companyInformationVo;
  }
}
