package com.biz.crm.dms.business.interaction.local.service.notice;

import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeEntity;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeDto;

import java.util.List;

/**
 * 公告表服务接口
 *
 * @author ning.zhang
 * @date 2021-11-22 16:10:02
 */
public interface NoticeService {

  /**
   * 创建公告
   *
   * @param dto 参数dto
   * @return 创建的公告
   */
  NoticeEntity create(NoticeDto dto);

  /**
   * 更新公告
   *
   * @param dto 参数dto
   * @return 更新的公告
   */
  NoticeEntity update(NoticeDto dto);

  /**
   * 批量删除公告
   *
   * @param ids 公告id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 批量启用公告
   *
   * @param ids 公告id集合
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用公告
   *
   * @param ids 公告id集合
   */
  void disableBatch(List<String> ids);
}
