package com.biz.crm.dms.business.interaction.local.service.notice.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeReadRecordEntity;
import com.biz.crm.dms.business.interaction.local.repository.notice.NoticeReadRecordRepository;
import com.biz.crm.dms.business.interaction.local.service.notice.NoticeReadRecordService;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeReadRecordDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * 公告阅读记录表服务实现类
 *
 * @author ning.zhang
 * @date 2021-11-30 10:16:18
 */
@Slf4j
@Service("noticeReadRecordService")
public class NoticeReadRecordServiceImpl implements NoticeReadRecordService {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private NoticeReadRecordRepository noticeReadRecordRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public NoticeReadRecordEntity create(NoticeReadRecordDto dto) {
    Validate.notNull(dto, "进行当前操作时，信息对象必须传入!");
    dto.setId(null);
    dto.setTenantCode(TenantUtils.getTenantCode());
    LoginUserDetailsForEMS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
    Validate.isTrue(!ObjectUtils.isEmpty(loginDetails),"没有登录信息");
    dto.setCustomerCode(loginDetails.getCustomerCode());
    Validate.notBlank(dto.getCustomerCode(), "缺失客户编码");
    Validate.notBlank(dto.getNoticeId(), "缺失公告ID");
    NoticeReadRecordEntity recordEntity = this.noticeReadRecordRepository.findByNoticeIdAndCustomerCode(dto.getNoticeId(), dto.getCustomerCode());
    if (Objects.nonNull(recordEntity)) {
      log.info("该客户已经阅读了此公告!");
      return recordEntity;
    }
    NoticeReadRecordEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(dto, NoticeReadRecordEntity.class, HashSet.class, ArrayList.class);
    this.noticeReadRecordRepository.save(entity);
    return entity;
  }
}
