package com.biz.crm.dms.business.interaction.local.controller.carouselPicture;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.local.entity.carouselPicture.CarouselPictureEntity;
import com.biz.crm.dms.business.interaction.local.service.carouselPicture.CarouselPictureService;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPictureCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPictureDto;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPicturePageDto;
import com.biz.crm.dms.business.interaction.sdk.vo.carouselPicture.CarouselPictureVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 客户互动：carouselPicture 轮播图
 */
@Slf4j
@Api(tags = "客户互动: CarouselPicture：轮播图")
@RestController
@RequestMapping("/v1/carouselPicture/carouselPicture")
public class CarouselPictureController {
  @Autowired(required = false)
  CarouselPictureService carouselPictureService;

  @ApiOperation(value = "添加图片")
  @PostMapping("")
  public Result<?> create(@RequestBody CarouselPictureDto dto) {
    try {
      return Result.ok(carouselPictureService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage());
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新图片")
  @PatchMapping("/update")
  public Result<?> update(@RequestBody CarouselPictureDto dto) {
    try {
      return Result.ok(carouselPictureService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage());
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result<?> enableBatch(@RequestBody List<String> ids) {
    try {
      carouselPictureService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage());
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result<?> disableBatch(@RequestBody List<String> ids) {
    try {
      carouselPictureService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage());
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result<?> deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      carouselPictureService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage());
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "客户-图片分页查询")
  @GetMapping("/findByCarouselPictureCustomerPageDto")
  public Result<Page<CarouselPictureEntity>> findByCarouselPictureCustomerPageDto(@PageableDefault(50) Pageable pageable, @ApiParam(name = "carouselPictureCustomerPageDto", value = "图片客户页面dto") CarouselPictureCustomerPageDto dto){
    try {
      return Result.ok(carouselPictureService.findByCarouselPictureCustomerPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage());
      return Result.error(e.getMessage());
    }
  }
}
