package com.biz.crm.dms.business.interaction.local.controller.complaint;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintReplyEntity;
import com.biz.crm.dms.business.interaction.local.service.complaint.ComplaintReplyService;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintReplyDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户互动: ComplaintReply: 投诉建议管理
 *
 * @author ning.zhang
 * @date 2021/11/16
 */
@Slf4j
@RestController
@RequestMapping("/v1/complaintReply/complaintReply")
@Api(tags = "客户互动: ComplaintReply: 投诉回复")
public class ComplaintReplyController {

  @Autowired(required = false)
  private ComplaintReplyService complaintReplyService;

  /**
   * 新增投诉建议回复信息
   *
   * @param dto 参数dto
   * @return 新增的投诉建议回复
   */
  @ApiOperation(value = "新增投诉建议回复信息")
  @PostMapping("")
  public Result<ComplaintReplyEntity> create(@RequestBody ComplaintReplyDto dto) {
    try {
      return Result.ok(this.complaintReplyService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
