package com.biz.crm.dms.business.interaction.local.controller.complaint;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.sdk.service.complaint.ComplaintVoService;
import com.biz.crm.dms.business.interaction.sdk.vo.complaint.ComplaintVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户互动: ComplaintVo: 投诉建议管理
 *
 * @author ning.zhang
 * @date 2021/11/16
 */
@Slf4j
@RestController
@RequestMapping("/v1/complaint/complaint")
@Api(tags = "客户互动: ComplaintVo: 投诉建议")
public class ComplaintVoController {

  @Autowired(required = false)
  private ComplaintVoService complaintVoService;

  /**
   * 通过ID获取投诉详细信息
   *
   * @param id 投诉ID
   * @return 投诉信息
   */
  @ApiOperation(value = "通过ID获取投诉详细信息")
  @GetMapping("/findById")
  public Result<ComplaintVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.complaintVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
