package com.biz.crm.dms.business.interaction.local.controller.information;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationEntity;
import com.biz.crm.dms.business.interaction.local.service.information.CompanyInformationService;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationDto;
import com.biz.crm.dms.business.interaction.sdk.dto.information.CompanyInformationPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 客户互动: CompanyInformation: 公司资料管理
 *
 * @author ning.zhang
 * @date 2021/11/24
 */
@Slf4j
@RestController
@RequestMapping("/v1/companyInformation/companyInformation")
@Api(tags = "客户互动: CompanyInformation: 公司资料管理")
public class CompanyInformationController {

  @Autowired(required = false)
  private CompanyInformationService companyInformationService;

  /**
   * 新增公司资料信息
   *
   * @param dto 参数dto
   * @return 新增公司资料数据
   */
  @ApiOperation(value = "新增公司资料")
  @PostMapping("")
  public Result create(@RequestBody CompanyInformationDto dto) {
    try {
      return Result.ok(this.companyInformationService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新公司资料信息
   *
   * @param dto 参数dto
   * @return 更新后公司资料数据
   */
  @ApiOperation(value = "更新公司资料信息")
  @PatchMapping("")
  public Result update(@RequestBody CompanyInformationDto dto) {
    try {
      return Result.ok(this.companyInformationService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除公司资料
   *
   * @param ids 公司资料id集合
   * @return 操作结果
   */
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.companyInformationService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用公司资料
   *
   * @param ids 公司资料id集合
   * @return 操作结果
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enableBatch")
  public Result enableBatch(@RequestBody List<String> ids) {
    try {
      this.companyInformationService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用公司资料
   *
   * @param ids 公司资料id集合
   * @return 操作结果
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disableBatch")
  public Result disableBatch(@RequestBody List<String> ids) {
    try {
      this.companyInformationService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 公告分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 公告分页数据
   */
  @ApiOperation(value = "公告分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<CompanyInformationEntity>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "CompanyInformationPageDto", value = "分页Dto") CompanyInformationPageDto dto) {
    try {
      return Result.ok(this.companyInformationService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 客户-公告分页查询
   *
   * @param pageable 分页信息
   * @param dto      参数Dto
   * @return 公告分页数据
   */
  @ApiOperation(value = "客户-公告分页查询")
  @GetMapping("/findByCompanyInformationCustomerPageDto")
  public Result<Page<CompanyInformationEntity>> findByCompanyInformationCustomerPageDto(@PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "CompanyInformationCustomerPageDto", value = "分页Dto") CompanyInformationCustomerPageDto dto) {
    try {
      return Result.ok(this.companyInformationService.findByCompanyInformationCustomerPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
