package com.biz.crm.dms.business.interaction.local.controller.information;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.sdk.service.information.CompanyInformationVoService;
import com.biz.crm.dms.business.interaction.sdk.vo.information.CompanyInformationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户互动: CompanyInformationVo: 公司资料管理
 *
 * @author ning.zhang
 * @date 2021/11/16
 */
@Slf4j
@RestController
@RequestMapping("/v1/companyInformation/companyInformation")
@Api(tags = "客户互动: CompanyInformationVo: 公司资料管理")
public class CompanyInformationVoController {

  @Autowired(required = false)
  private CompanyInformationVoService companyInformationVoService;

  /**
   * 通过ID获取公司资料信息
   *
   * @param id 公司资料ID
   * @return 操作结果
   */
  @ApiOperation(value = "通过ID获取公司资料信息")
  @GetMapping("/findById")
  public Result<CompanyInformationVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.companyInformationVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
