package com.biz.crm.dms.business.interaction.local.controller.notice;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeReadRecordEntity;
import com.biz.crm.dms.business.interaction.local.service.notice.NoticeReadRecordService;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeReadRecordDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户互动: NoticeReadRecord: 公告阅读记录
 *
 * @author ning.zhang
 * @date 2021-11-30 10:16:18
 */
@Slf4j
@RestController
@RequestMapping(value = {"/v1/noticeReadRecord/noticeReadRecord"})
@Api(tags = "客户互动: NoticeReadRecord: 公告阅读记录")
public class NoticeReadRecordController {

  @Autowired(required = false)
  private NoticeReadRecordService noticeReadRecordService;

  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<NoticeReadRecordEntity> create(@RequestBody NoticeReadRecordDto dto) {
    try {
      return Result.ok(this.noticeReadRecordService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
