package com.biz.crm.dms.business.interaction.local.entity.carouselPicture;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author huangzhi
 */

@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CarouselPictureEntity", description = "轮播图图片信息")
@Entity
@TableName("dms_carousel_picture")
@Table(name = "dms_carousel_picture", indexes = {
    @Index(name = "dms_carousel_picture_index1", columnList = "tenant_code")
})
@org.hibernate.annotations.Table(appliesTo = "dms_carousel_picture", comment = "轮播图图片信息")
public class CarouselPictureEntity extends TenantFlagOpEntity {

  /**
   * 图片顺序
   */
  @ApiModelProperty("图片顺序")
  @Column(name = "picture_sort", columnDefinition = "int(5) COMMENT ' 图片 '")
  private Integer pictureSort;

  /**
   * 图片描述
   */
  @ApiModelProperty("图片描述")
  @Column(name = "picture_description", columnDefinition = "varchar(64) COMMENT ' 图片描述 '")
  private String pictureDescription;

  /**
   * 文件唯一识别号
   */
  @ApiModelProperty(value = "文件唯一识别号")
  @TableField(value = "file_code")
  @Column(name = "file_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文件唯一识别号'")
  private String fileCode;

  /**
   * 原始文件名
   */
  @ApiModelProperty(name="originalFileName" , value="原始文件名")
  @TableField(value = "original_name")
  @Column(name = "original_name", nullable = true, columnDefinition = "varchar(255) COMMENT '原始文件名'")
  private String originalFileName;

  /**
   * 跳转地址
   */
  @ApiModelProperty("跳转地址")
  @Column(name = "destination_address", columnDefinition = "varchar(64) COMMENT ' 跳转地址 '")
  private String destinationAddress;

  /**
   * 有效开始时间
   */
  @ApiModelProperty("有效开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "start_time", columnDefinition = "datetime COMMENT ' 有效开始时间 '")
  private Date startTime;

  /**
   * 有效结束时间
   */
  @ApiModelProperty("有效结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "end_time", columnDefinition = "datetime COMMENT ' 有效结束时间 '")
  private Date endTime;

  /**
   * 该图片可见客户列表
   */
  @ApiModelProperty("可见用户范围列表")
  @Transient
  @TableField(exist = false)
  private List<CarouselPictureScopeEntity> scopeList;
}
