package com.biz.crm.dms.business.interaction.local.entity.carouselPicture;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@Data
@ApiModel(value = "CarouselPictureScopeEntity", description = "图片可见范围实体类")
@Entity
@TableName("dms_picture_scope")
@Table(name = "dms_picture_scope", indexes = {
    @Index(name = "dms_picture_scope_index1", columnList = "scope_code"),
    @Index(name = "dms_picture_scope_index2", columnList = "picture_id"),
    @Index(name = "dms_picture_scope_index3", columnList = "tenant_code")})
@org.hibernate.annotations.Table(appliesTo = "dms_picture_scope", comment = "图片可见范围表")
public class CarouselPictureScopeEntity extends TenantEntity {
  @ApiModelProperty("图片id")
  @Column(name = "picture_id", length = 64, columnDefinition = "varchar(64) COMMENT'图片id'")
  private String pictureId;

  @ApiModelProperty("范围编码")
  @Column(name = "scope_code", length = 64, columnDefinition = "varchar(64) COMMENT'范围编码'")
  private String scopeCode;

  @ApiModelProperty("范围类型")
  @Column(name = "scope_type", length = 32, columnDefinition = "varchar(64) COMMENT'范围类型'")
  private String scopeType;
}
