package com.biz.crm.dms.business.interaction.local.entity.complaint;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 投诉文件实体类
 *
 * @author ning.zhang
 * @date 2021/11/24
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ComplaintEntity", description = "投诉文件实体类")
@Entity
@TableName("dms_complaint_file")
@Table(name = "dms_complaint_file", indexes = {
    @Index(name = "dms_complaint_index1", columnList = "tenant_code"),
    @Index(name = "dms_complaint_index2", columnList = "complaint_id"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_complaint_file", comment = "投诉文件表")
public class ComplaintFileEntity extends FileEntity {

  private static final long serialVersionUID = 231358355849359865L;

  /**
   * 投诉id
   */
  @ApiModelProperty("投诉id")
  @Column(name = "complaint_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '投诉id'")
  private String complaintId;

  /**
   * 文件显示顺序
   */
  @ApiModelProperty("文件显示顺序")
  @Column(name = "sort_num", length = 5, columnDefinition = "int(5) COMMENT '文件显示顺序'")
  private Integer sortNum;
}
