package com.biz.crm.dms.business.interaction.local.entity.complaint;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 投诉回复实体类
 *
 * @author ning.zhang
 * @date 2021/11/24
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ComplaintReplyEntity", description = "投诉回复实体类")
@Entity
@TableName("dms_complaint_reply")
@Table(name = "dms_complaint_reply", indexes = {
    @Index(name = "dms_complaint_index1", columnList = "tenant_code"),
    @Index(name = "dms_complaint_index2", columnList = "complaint_id"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_complaint_reply", comment = "投诉回复表")
public class ComplaintReplyEntity extends TenantOpEntity {

  private static final long serialVersionUID = -7401023509714736284L;

  /**
   * 投诉id
   */
  @ApiModelProperty("投诉id")
  @Column(name = "complaint_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '投诉id'")
  private String complaintId;

  /**
   * 回复内容
   */
  @ApiModelProperty("回复内容")
  @Column(name = "reply_content", length = 500, columnDefinition = "VARCHAR(500) COMMENT '回复内容'")
  private String replyContent;

  /**
   * 回复人类型(0:厂家,1:客户)
   */
  @ApiModelProperty("回复人类型(0:厂家,1:客户)")
  @Column(name = "replier_type", columnDefinition = "VARCHAR(10) COMMENT '回复人类型(0:厂家,1:客户)'")
  private String replierType;

  /**
   * 投诉回复文件关联信息
   */
  @ApiModelProperty("投诉回复文件关联信息")
  @Transient
  @TableField(exist = false)
  private List<ComplaintReplyFileEntity> fileList;
}
