package com.biz.crm.dms.business.interaction.local.entity.information;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * 公司资料实体类
 *
 * @author ning.zhang
 * @date 2021/11/24
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CompanyInformationEntity", description = "公司资料实体类")
@Entity
@TableName("dms_company_information")
@Table(name = "dms_company_information", indexes = {
    @Index(name = "dms_notice_index1", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_company_information", comment = "公司资料表")
public class CompanyInformationEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = -1603009466477876321L;

  /**
   * 资料名称
   */
  @ApiModelProperty("资料名称")
  @Column(name = "name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '资料名称'")
  private String name;

  /**
   * 资料类型
   */
  @ApiModelProperty("资料类型")
  @Column(name = "type", length = 10, columnDefinition = "VARCHAR(10) COMMENT '资料类型'")
  private String type;

  /**
   * 生效开始时间
   */
  @ApiModelProperty("生效开始时间")
  @Column(name = "start_time", columnDefinition = "datetime COMMENT '生效开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /**
   * 生效结束时间
   */
  @ApiModelProperty("生效结束时间")
  @Column(name = "end_time", columnDefinition = "datetime COMMENT '生效结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /**
   * 公司资料文件关联信息
   */
  @ApiModelProperty("公司资料文件关联信息")
  @Transient
  @TableField(exist = false)
  private List<CompanyInformationFileEntity> fileList;

  /**
   * 公司资料范围关联信息
   */
  @ApiModelProperty("公司资料范围关联信息")
  @Transient
  @TableField(exist = false)
  private List<CompanyInformationScopeEntity> scopeList;
}
