package com.biz.crm.dms.business.interaction.local.mapper.complaint;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintEntity;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintPageDto;
import org.apache.ibatis.annotations.Param;

/**
 * 投诉表的mybatis-plus接口类 {@link ComplaintEntity}
 *
 * @author ning.zhang
 * @date 2021-11-24 16:38:47
 */
public interface ComplaintMapper extends BaseMapper<ComplaintEntity> {

  /**
   * 客户-投诉分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<ComplaintEntity> 投诉分页信息
   */
  Page<ComplaintEntity> findByComplaintCustomerPageDto(Page<ComplaintEntity> page, @Param("dto") ComplaintCustomerPageDto dto);

  /**
   * 投诉分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<ComplaintEntity> 投诉分页信息
   */
  Page<ComplaintEntity> findByConditions(Page<ComplaintEntity> page, @Param("dto") ComplaintPageDto dto);

  /**
   * 通过ID获取投诉信息
   *
   * @param id 投诉ID
   * @return 投诉信息
   */
  ComplaintEntity findById(@Param("id") String id);
}

