package com.biz.crm.dms.business.interaction.local.mapper.notice;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeEntity;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeCustomerPageDto;
import org.apache.ibatis.annotations.Param;

/**
 * 公告表的mybatis-plus接口类 {@link NoticeEntity}
 *
 * @author ning.zhang
 * @date 2021-11-22 16:10:02
 */
public interface NoticeMapper extends BaseMapper<NoticeEntity> {

  /**
   * 客户-公告分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<NoticeEntity> findByNoticeCustomerPageDto(Page<NoticeEntity> page, @Param("dto") NoticeCustomerPageDto dto);

  /**
   * 通过ID获取公告信息
   *
   * @param id 公告ID
   * @return 公告信息
   */
  NoticeEntity findById(@Param("id") String id);
}

