package com.biz.crm.dms.business.interaction.local.repository.carouselPicture;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.interaction.local.entity.carouselPicture.CarouselPictureEntity;
import com.biz.crm.dms.business.interaction.local.mapper.carouselPicture.CarouselPictureMapper;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPictureCustomerPageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 图片范围表的数据库访问类 {@link CarouselPictureEntity}
 *
 * @author huangzhi
 * @date 2021年11月23日
 */
@Component
public class CarouselPictureRepository extends ServiceImpl<CarouselPictureMapper, CarouselPictureEntity> {

  /**
   * 通过id批量删除
   *
   * @param ids 图片id
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(CarouselPictureEntity::getId, ids)
        .set(CarouselPictureEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新禁请用状态
   *
   * @param ids 图片id
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(CarouselPictureEntity::getId, ids)
        .set(CarouselPictureEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 通过id获取图片信息
   *
   * @param id 图片id
   * @return 图片信息
   */
  public CarouselPictureEntity findById(String id) {
    return this.baseMapper.findById(id);
  }

  /**
   * 客户-图片分页列表
   * @param pageable 图片信息
   * @param dto 图片客户页面dto
   * @return 图片分页信息
   */
  public Page<CarouselPictureEntity> findByCarouselPictureCustomerPageDto(Pageable pageable, CarouselPictureCustomerPageDto dto){
    Page<CarouselPictureEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByCarouselPictureCustomerPageDto(page, dto);
  }
}
