package com.biz.crm.dms.business.interaction.local.repository.carouselPicture;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.interaction.local.entity.carouselPicture.CarouselPictureScopeEntity;
import com.biz.crm.dms.business.interaction.local.mapper.carouselPicture.CarouselPictureScopeMapper;
import org.springframework.stereotype.Component;

/**
 * 图片范围表的数据库访问类 {@link CarouselPictureScopeEntity}
 */
@Component
public class CarouselPictureScopeRepository extends ServiceImpl<CarouselPictureScopeMapper, CarouselPictureScopeEntity> {
  /**
   * 通过图片id删除图片范围客户或组织
   *
   * @param pictureId 图片id
   */
  public void deleteByPictureId(String pictureId) {
    this.lambdaUpdate().eq(CarouselPictureScopeEntity::getPictureId, pictureId)
        .remove();
  }
}
