package com.biz.crm.dms.business.interaction.local.repository.carouselPicture;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.interaction.local.entity.carouselPicture.CarouselPictureEntity;
import com.biz.crm.dms.business.interaction.local.mapper.carouselPicture.CarouselPictureVoMapper;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPicturePageDto;
import com.biz.crm.dms.business.interaction.sdk.vo.carouselPicture.CarouselPictureVo;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 图片范围表的数据库访问类 {@link CarouselPictureEntity}
 *
 * @author lww
 * @date 2022年3月1日
 */
@Component
public class CarouselPictureVoRepository extends ServiceImpl<CarouselPictureVoMapper, CarouselPictureVo> {

  /**
   * 图片分页列表
   * @param pageable 图片信息
   * @param dto 图片页面dto
   * @return 图片分页信息
   */
  public Page<CarouselPictureVo> findByConditions(Pageable pageable, CarouselPicturePageDto dto) {
    Page<CarouselPictureVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
