package com.biz.crm.dms.business.interaction.local.repository.complaint;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintEntity;
import com.biz.crm.dms.business.interaction.local.mapper.complaint.ComplaintMapper;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintPageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 投诉表的数据库访问类 {@link ComplaintEntity}
 *
 * @author ning.zhang
 * @date 2021-11-24 16:38:47
 */
@Component
public class ComplaintRepository extends ServiceImpl<ComplaintMapper, ComplaintEntity> {

  /**
   * 根据投诉id更新投诉状态
   *
   * @param complaintState 投诉状态
   * @param id             投诉id
   */
  public void updateComplaintStateById(String complaintState, String id) {
    this.lambdaUpdate()
        .eq(ComplaintEntity::getId, id)
        .set(ComplaintEntity::getComplaintState, complaintState)
        .update();
  }

  /**
   * 投诉分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ComplaintEntity> 投诉分页信息
   */
  public Page<ComplaintEntity> findByConditions(Pageable pageable, ComplaintPageDto dto) {
    Page<ComplaintEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 客户-投诉分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ComplaintEntity> 投诉分页信息
   */
  public Page<ComplaintEntity> findByComplaintCustomerPageDto(Pageable pageable, ComplaintCustomerPageDto dto) {
    Page<ComplaintEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByComplaintCustomerPageDto(page, dto);
  }

  /**
   * 通过ID获取投诉信息
   *
   * @param id 投诉ID
   * @return 投诉信息
   */
  public ComplaintEntity findById(String id) {
    return this.baseMapper.findById(id);
  }
}
