package com.biz.crm.dms.business.interaction.local.repository.information;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationFileEntity;
import com.biz.crm.dms.business.interaction.local.mapper.information.CompanyInformationFileMapper;
import org.springframework.stereotype.Component;

/**
 * 公司资料文件表的数据库访问类 {@link CompanyInformationFileEntity}
 *
 * @author ning.zhang
 * @date 2021-11-24 13:35:21
 */
@Component
public class CompanyInformationFileRepository extends ServiceImpl<CompanyInformationFileMapper, CompanyInformationFileEntity> {

  /**
   * 通过公司资料ID删除公司资料文件信息
   *
   * @param informationId 公司资料ID
   */
  public void deleteByInformationId(String informationId) {
    this.lambdaUpdate()
        .eq(CompanyInformationFileEntity::getInformationId, informationId)
        .remove();
  }
}
