package com.biz.crm.dms.business.interaction.local.repository.information;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationScopeEntity;
import com.biz.crm.dms.business.interaction.local.mapper.information.CompanyInformationScopeMapper;
import org.springframework.stereotype.Component;

/**
 * 公司资料范围表的数据库访问类 {@link CompanyInformationScopeEntity}
 *
 * @author ning.zhang
 * @date 2021-11-24 13:35:44
 */
@Component
public class CompanyInformationScopeRepository extends ServiceImpl<CompanyInformationScopeMapper, CompanyInformationScopeEntity> {

  /**
   * 通过公司资料ID删除公司资料范围信息
   *
   * @param informationId 公司资料ID
   */
  public void deleteByInformationId(String informationId) {
    this.lambdaUpdate()
        .eq(CompanyInformationScopeEntity::getInformationId, informationId)
        .remove();
  }
}
