package com.biz.crm.dms.business.interaction.local.repository.notice;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeEntity;
import com.biz.crm.dms.business.interaction.local.mapper.notice.NoticeMapper;
import com.biz.crm.dms.business.interaction.local.mapper.notice.NoticeModelMapper;
import com.biz.crm.dms.business.interaction.local.model.NoticeModelVo;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticePageDto;
import com.biz.crm.dms.business.interaction.sdk.vo.notice.NoticeVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公告内部模板数据库访问类
 *
 * @author ning.zhang
 * @date 2021-11-22 16:10:02
 */
@Component
public class NoticeModelRepository {

  @Autowired(required = false)
  private NoticeModelMapper noticeModelMapper;

  /**
   * 公告分页列表
   *
   * @param pageable 分页信息
   * @param dto  分页参数dto
   * @return Page<NoticeModelVo> 分页列表
   */
  public Page<NoticeModelVo> findByConditions(Pageable pageable, NoticePageDto dto) {
    Page<NoticeModelVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.noticeModelMapper.findByConditions(page, dto);
  }
}
