package com.biz.crm.dms.business.interaction.local.repository.notice;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeReadRecordEntity;
import com.biz.crm.dms.business.interaction.local.mapper.notice.NoticeReadRecordMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公告阅读记录表的数据库访问类 {@link NoticeReadRecordEntity}
 *
 * @author ning.zhang
 * @date 2021-11-30 10:16:18
 */
@Component
public class NoticeReadRecordRepository extends ServiceImpl<NoticeReadRecordMapper, NoticeReadRecordEntity> {

  /**
   * 通过公告ID和客户编码查询公告阅读记录
   *
   * @param noticeId     公告ID
   * @param customerCode 客户编码
   * @return 公告阅读记录
   */
  public NoticeReadRecordEntity findByNoticeIdAndCustomerCode(String noticeId, String customerCode) {
    return this.lambdaQuery()
        .eq(NoticeReadRecordEntity::getNoticeId, noticeId)
        .eq(NoticeReadRecordEntity::getCustomerCode, customerCode)
        .one();
  }

  /**
   * 通过公告ID集合和客户编码查询公告阅读记录
   *
   * @param noticeIds    公告ID集合
   * @param customerCode 客户编码
   * @return 公告阅读记录集合
   */
  public List<NoticeReadRecordEntity> findByNoticeIdsAndCustomerCode(List<String> noticeIds, String customerCode) {
    return this.lambdaQuery()
        .in(NoticeReadRecordEntity::getNoticeId, noticeIds)
        .eq(NoticeReadRecordEntity::getCustomerCode, customerCode)
        .select(NoticeReadRecordEntity::getNoticeId, NoticeReadRecordEntity::getCustomerCode)
        .list();
  }
}
