package com.biz.crm.dms.business.interaction.local.repository.notice;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeEntity;
import com.biz.crm.dms.business.interaction.local.mapper.notice.NoticeMapper;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeCustomerPageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公告表的数据库访问类 {@link NoticeEntity}
 *
 * @author ning.zhang
 * @date 2021-11-22 16:10:02
 */
@Component
public class NoticeRepository extends ServiceImpl<NoticeMapper, NoticeEntity> {

  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(NoticeEntity::getId, ids)
        .set(NoticeEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param ids          ID集合
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(NoticeEntity::getId, ids)
        .set(NoticeEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 客户-公告分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<NoticeEntity>公告分页信息
   */
  public Page<NoticeEntity> findByNoticeCustomerPageDto(Pageable pageable, NoticeCustomerPageDto dto) {
    Page<NoticeEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByNoticeCustomerPageDto(page, dto);
  }

  /**
   * 通过ID获取公告信息
   *
   * @param id 公告ID
   * @return 公告信息
   */
  public NoticeEntity findById(String id) {
    return this.baseMapper.findById(id);
  }
}
