package com.biz.crm.dms.business.interaction.local.service.carouselPicture;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.interaction.local.entity.carouselPicture.CarouselPictureEntity;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPictureCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPictureDto;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPicturePageDto;
import com.biz.crm.dms.business.interaction.sdk.vo.carouselPicture.CarouselPictureVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 图片信息Service接口
 *
 * @author huangzhi
 */
public interface CarouselPictureService {
  /**
   * 创建图片
   *
   * @param dto 图片信息dto
   */
  CarouselPictureEntity create(CarouselPictureDto dto);

  /**
   * 更新图片
   *
   * @param dto 图片信息dto
   */
  CarouselPictureEntity update(CarouselPictureDto dto);

  /**
   * 批量删除
   *
   * @param ids 图片id
   */
  void deleteBatch(List<String> ids);

  /**
   * 通过id批量启用
   *
   * @param ids 图片id
   */
  void enableBatch(List<String> ids);

  /**
   * 通过id批量禁用
   *
   * @param ids 图片id
   */
  void disableBatch(List<String> ids);


  /**
   * 客户-图片信息分页列表
   * @param pageable 分页信息
   * @param dto 图片客户页面dto
   * @return 图片分页信息
   */
  Page<CarouselPictureEntity> findByCarouselPictureCustomerPageDto(Pageable pageable, CarouselPictureCustomerPageDto dto);
}
