package com.biz.crm.dms.business.interaction.local.service.complaint;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintEntity;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintStateDto;
import org.springframework.data.domain.Pageable;

/**
 * 投诉表服务接口
 *
 * @author ning.zhang
 * @date 2021-11-24 16:38:48
 */
public interface ComplaintService {

  /**
   * 创建投诉
   *
   * @param dto 参数dto
   * @return 创建的投诉
   */
  ComplaintEntity create(ComplaintDto dto);

  /**
   * 更新投诉状态
   *
   * @param dto 参数dto
   */
  void updateComplaintState(ComplaintStateDto dto);

  /**
   * 客户-投诉分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ComplaintEntity> 投诉分页信息
   */
  Page<ComplaintEntity> findByComplaintCustomerPageDto(Pageable pageable, ComplaintCustomerPageDto dto);

  /**
   * 投诉分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<ComplaintEntity> 投诉分页信息
   */
  Page<ComplaintEntity> findByConditions(Pageable pageable, ComplaintPageDto dto);
}
