package com.biz.crm.dms.business.interaction.local.service.complaint.internal;

import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintReplyFileEntity;
import com.biz.crm.dms.business.interaction.local.repository.complaint.ComplaintReplyFileRepository;
import com.biz.crm.dms.business.interaction.local.service.complaint.ComplaintReplyFileService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.InteractionFileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 投诉回复文件表服务实现类
 *
 * @author ning.zhang
 * @date 2021-11-24 16:40:33
 */
@Slf4j
@Service("complaintReplyFileService")
public class ComplaintReplyFileServiceImpl implements ComplaintReplyFileService {

  @Autowired(required = false)
  private ComplaintReplyFileRepository complaintReplyFileRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void create(List<InteractionFileDto> dtoList, String replyId) {
    Validate.notBlank(replyId, "投诉回复ID不能为空");
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    String tenantCode = TenantUtils.getTenantCode();
    //过滤无效的数据
    List<ComplaintReplyFileEntity> entities = dtoList.stream()
        .filter(Objects::nonNull)
        .map(dto -> {
          ComplaintReplyFileEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(dto, ComplaintReplyFileEntity.class, HashSet.class, ArrayList.class);
          entity.setReplyId(replyId);
          entity.setTenantCode(tenantCode);
          entity.setSortNum(dtoList.indexOf(dto));
          entity.setFileCode(dto.getFileCode());
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    this.complaintReplyFileRepository.saveBatch(entities);
  }
}
