package com.biz.crm.dms.business.interaction.local.service.information.internal;

import com.biz.crm.dms.business.interaction.local.entity.information.CompanyInformationFileEntity;
import com.biz.crm.dms.business.interaction.local.repository.information.CompanyInformationFileRepository;
import com.biz.crm.dms.business.interaction.local.service.information.CompanyInformationFileService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.InteractionFileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 公司资料文件表服务实现类
 *
 * @author ning.zhang
 * @date 2021-11-24 13:35:21
 */
@Slf4j
@Service("companyInformationFileService")
public class CompanyInformationFileServiceImpl implements CompanyInformationFileService {

  @Autowired(required = false)
  private CompanyInformationFileRepository companyInformationFileRepository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(List<InteractionFileDto> dtoList, String informationId) {
    Validate.notBlank(informationId, "公司资料ID不能为空");
    this.companyInformationFileRepository.deleteByInformationId(informationId);
    //TODO 删除文件系统文件数据
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    String tenantCode = TenantUtils.getTenantCode();
    //过滤无效的数据
    List<CompanyInformationFileEntity> entities = dtoList.stream()
        .filter(Objects::nonNull)
        .map(dto -> {
          CompanyInformationFileEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(dto, CompanyInformationFileEntity.class, HashSet.class, ArrayList.class);
          entity.setInformationId(informationId);
          entity.setTenantCode(tenantCode);
          entity.setSortNum(dtoList.indexOf(dto));
          entity.setFileCode(dto.getFileCode());
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    this.companyInformationFileRepository.saveBatch(entities);
  }
  
}
