package com.biz.crm.dms.business.interaction.local.service.notice.internal;

import com.biz.crm.dms.business.interaction.local.entity.notice.NoticeScopeEntity;
import com.biz.crm.dms.business.interaction.local.repository.notice.NoticeScopeRepository;
import com.biz.crm.dms.business.interaction.local.service.notice.NoticeScopeService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.ScopeDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 公告范围表服务实现类
 *
 * @author ning.zhang
 * @date 2021-11-22 16:12:29
 */
@Slf4j
@Service("noticeScopeService")
public class NoticeScopeServiceImpl implements NoticeScopeService {

  @Autowired(required = false)
  private NoticeScopeRepository noticeScopeRepository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(List<ScopeDto> dtoList, String noticeId) {
    Validate.notBlank(noticeId, "公告ID不能为空");
    this.noticeScopeRepository.deleteByNoticeId(noticeId);
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    String tenantCode = TenantUtils.getTenantCode();
    //过滤无效的数据
    List<NoticeScopeEntity> entities = dtoList.stream()
        .filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty(dto.getScopeCode()) && StringUtils.isNotEmpty(dto.getScopeType()))
        .map(dto -> {
          NoticeScopeEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(dto, NoticeScopeEntity.class, HashSet.class, ArrayList.class);
          entity.setNoticeId(noticeId);
          entity.setTenantCode(tenantCode);
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    this.noticeScopeRepository.saveBatch(entities);
  }
}
