/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.controller.complaint;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintEntity;
import com.biz.crm.dms.business.interaction.local.service.complaint.ComplaintService;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.complaint.ComplaintStateDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/complaint/complaint"})
@Api(tags={"\u5ba2\u6237\u4e92\u52a8: Complaint: \u6295\u8bc9\u5efa\u8bae"})
public class ComplaintController {
    private static final Logger log = LoggerFactory.getLogger(ComplaintController.class);
    @Autowired(required=false)
    private ComplaintService complaintService;

    @ApiOperation(value="\u65b0\u589e\u6295\u8bc9\u5efa\u8bae")
    @PostMapping(value={""})
    public Result<ComplaintEntity> create(@RequestBody ComplaintDto dto) {
        try {
            return Result.ok((Object)((Object)this.complaintService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u6295\u8bc9\u72b6\u6001(\u89e3\u51b3,\u64a4\u9500)")
    @PatchMapping(value={""})
    public Result<?> updateComplaintState(@RequestBody ComplaintStateDto dto) {
        try {
            this.complaintService.updateComplaintState(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u6295\u8bc9\u72b6\u6001")
    @PostMapping(value={"updateComplaintStateTurnPatch"})
    public Result<?> updateComplaintStateTurnPatch(@RequestBody ComplaintStateDto dto) {
        try {
            this.complaintService.updateComplaintState(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6295\u8bc9\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ComplaintEntity>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="ComplaintCustomerPageDto", value="\u5206\u9875Dto") ComplaintPageDto dto) {
        try {
            return Result.ok(this.complaintService.findByConditions(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u6237-\u6295\u8bc9\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByComplaintCustomerPageDto"})
    public Result<Page<ComplaintEntity>> findByComplaintCustomerPageDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="ComplaintCustomerPageDto", value="\u5206\u9875Dto") ComplaintCustomerPageDto dto) {
        try {
            return Result.ok(this.complaintService.findByComplaintCustomerPageDto(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

