/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.controller.notice;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.interaction.local.service.notice.NoticeService;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/notice/notice"})
@Api(tags={"\u5ba2\u6237\u4e92\u52a8: Notice: \u516c\u544a\u7ba1\u7406"})
public class NoticeController {
    private static final Logger log = LoggerFactory.getLogger(NoticeController.class);
    @Autowired(required=false)
    private NoticeService noticeService;

    @ApiOperation(value="\u65b0\u589e\u516c\u544a")
    @PostMapping(value={""})
    public Result create(@RequestBody NoticeDto dto) {
        try {
            return Result.ok((Object)((Object)this.noticeService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u516c\u544a\u4fe1\u606f")
    @PatchMapping(value={""})
    public Result update(@RequestBody NoticeDto dto) {
        try {
            return Result.ok((Object)((Object)this.noticeService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.noticeService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result enableBatch(@RequestBody List<String> ids) {
        try {
            this.noticeService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result disableBatch(@RequestBody List<String> ids) {
        try {
            this.noticeService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

