/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.base;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.AbstractCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.enums.ScopeType;
import com.biz.crm.dms.business.interaction.sdk.vo.base.ScopeVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractRelationDataService {
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired
    private LoginUserService loginUserService;

    protected void buildCustomerPageDto(AbstractCustomerPageDto dto) {
        String customerCode = dto.getCustomerCode();
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return;
        }
        dto.setCustomerCode(customerCode);
        CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, dto.getCustomerCode());
        if (Objects.isNull(customerVo)) {
            return;
        }
        dto.setChannel(customerVo.getChannel());
        if (StringUtils.isBlank((CharSequence)customerVo.getOrgCode())) {
            return;
        }
        List orgList = this.orgVoService.findAllParentByOrgCodes((List)Lists.newArrayList((Object[])customerVo.getOrgCode().split(",")));
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            dto.setOrgCodeList(orgList.stream().map(OrgVo::getOrgCode).collect(Collectors.toList()));
        }
    }

    protected void perfectScopeInfo(List<ScopeVo> scopeList) {
        if (CollectionUtils.isEmpty(scopeList)) {
            return;
        }
        ArrayList orgCodes = Lists.newArrayList();
        ArrayList customerCodes = Lists.newArrayList();
        scopeList.forEach(scopeVo -> {
            if (ScopeType.ORG.name().equals(scopeVo.getScopeType())) {
                orgCodes.add(scopeVo.getScopeCode());
            }
            if (ScopeType.CUSTOMER.name().equals(scopeVo.getScopeType())) {
                customerCodes.add(scopeVo.getScopeCode());
            }
        });
        Map<String, OrgVo> orgMap = this.buildOrgMap(orgCodes);
        Map<String, CustomerVo> customerMap = this.buildCustomerMap(customerCodes);
        scopeList.forEach(scopeVo -> {
            if (ScopeType.ORG.name().equals(scopeVo.getScopeType())) {
                OrgVo orgVo = (OrgVo)orgMap.get(scopeVo.getScopeCode());
                scopeVo.setScopeName(orgVo != null ? orgVo.getOrgName() : null);
            }
            if (ScopeType.CUSTOMER.name().equals(scopeVo.getScopeType())) {
                CustomerVo customerVo = (CustomerVo)customerMap.get(scopeVo.getScopeCode());
                scopeVo.setScopeName(customerVo != null ? customerVo.getCustomerName() : null);
            }
        });
    }

    private Map<String, OrgVo> buildOrgMap(List<String> orgCodes) {
        Map<Object, Object> resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(orgCodes)) {
            return resultMap;
        }
        List orgVoList = this.orgVoService.findByOrgCodes(orgCodes);
        if (CollectionUtils.isEmpty((Collection)orgVoList)) {
            return resultMap;
        }
        resultMap = orgVoList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (key1, key2) -> key2));
        return resultMap;
    }

    private Map<String, CustomerVo> buildCustomerMap(List<String> customerCodes) {
        Map<Object, Object> resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(customerCodes)) {
            return resultMap;
        }
        List orgVoList = this.customerVoService.findByCustomerCodes(customerCodes);
        if (CollectionUtils.isEmpty((Collection)orgVoList)) {
            return resultMap;
        }
        resultMap = orgVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, t -> t, (key1, key2) -> key2));
        return resultMap;
    }
}

