/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.carouselPicture.internal;

import com.biz.crm.dms.business.interaction.local.entity.carouselPicture.CarouselPictureScopeEntity;
import com.biz.crm.dms.business.interaction.local.repository.carouselPicture.CarouselPictureScopeRepository;
import com.biz.crm.dms.business.interaction.local.service.carouselPicture.CarouselPictureScopeService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.ScopeDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CarouselPictureScopeServiceImpl
implements CarouselPictureScopeService {
    @Autowired(required=false)
    CarouselPictureScopeRepository carouselPictureScopeRepository;
    @Autowired(required=false)
    NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void update(List<ScopeDto> scopeDtoList, String pictureId) {
        Validate.notBlank((CharSequence)pictureId, (String)"\u56fe\u7247id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.carouselPictureScopeRepository.deleteByPictureId(pictureId);
        if (CollectionUtils.isEmpty(scopeDtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List entities = scopeDtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotBlank((CharSequence)dto.getScopeCode()) && StringUtils.isNotBlank((CharSequence)dto.getScopeType())).map(dto -> {
            CarouselPictureScopeEntity entity = (CarouselPictureScopeEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, CarouselPictureScopeEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setPictureId(pictureId);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.carouselPictureScopeRepository.saveBatch(entities);
    }
}

