/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.carouselPicture.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.interaction.local.entity.carouselPicture.CarouselPictureEntity;
import com.biz.crm.dms.business.interaction.local.repository.carouselPicture.CarouselPictureRepository;
import com.biz.crm.dms.business.interaction.local.service.base.AbstractRelationDataService;
import com.biz.crm.dms.business.interaction.local.service.carouselPicture.CarouselPictureScopeService;
import com.biz.crm.dms.business.interaction.local.service.carouselPicture.CarouselPictureService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.AbstractCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPictureCustomerPageDto;
import com.biz.crm.dms.business.interaction.sdk.dto.carouselPicture.CarouselPictureDto;
import com.biz.crm.dms.business.interaction.sdk.enums.ScopeType;
import com.biz.crm.dms.business.interaction.sdk.event.CarouselPictureEventListener;
import com.biz.crm.dms.business.interaction.sdk.vo.carouselPicture.CarouselPictureEventVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CarouselPictureServiceImpl
extends AbstractRelationDataService
implements CarouselPictureService {
    @Autowired(required=false)
    CarouselPictureRepository carouselPictureRepository;
    @Autowired(required=false)
    CarouselPictureScopeService carouselPictureScopeService;
    @Autowired(required=false)
    NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    List<CarouselPictureEventListener> listeners;

    private void createValidation(CarouselPictureDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getPictureDescription(), (String)"\u56fe\u7247\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getPictureSort(), (String)"\u56fe\u7247\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFileCode(), (String)"\u6587\u4ef6\u552f\u4e00\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.isTrue((boolean)dto.getStartTime().before(dto.getEndTime()), (String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u751f\u6548\u7ed3\u675f\u65f6\u95f4!", (Object[])new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)dto.getScopeList())) {
            dto.getScopeList().forEach(pictureScopeDto -> {
                List scopeTypeList = Arrays.stream(ScopeType.values()).map(Enum::name).filter(code -> !code.equals("CHANNEL")).collect(Collectors.toList());
                Validate.isTrue((boolean)scopeTypeList.contains(pictureScopeDto.getScopeType()), (String)"\u4e0d\u652f\u6301\u7684\u8303\u56f4\u7c7b\u578b!", (Object[])new Object[0]);
            });
        }
    }

    private void updateValidation(CarouselPictureDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u56fe\u7247id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPictureDescription(), (String)"\u56fe\u7247\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getPictureSort(), (String)"\u56fe\u7247\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFileCode(), (String)"\u6587\u4ef6\u552f\u4e00\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getStartTime(), (String)"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEndTime(), (String)"\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)dto.getStartTime().before(dto.getEndTime()), (String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u751f\u6548\u7ed3\u675f\u65f6\u95f4!", (Object[])new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)dto.getScopeList())) {
            dto.getScopeList().forEach(scopeDto -> {
                List scopeTypeList = Arrays.stream(ScopeType.values()).map(Enum::name).filter(code -> !code.equals(ScopeType.CHANNEL.name())).collect(Collectors.toList());
                Validate.isTrue((boolean)scopeTypeList.contains(scopeDto.getScopeType()), (String)"\u4e0d\u652f\u6301\u7684\u8303\u56f4\u7c7b\u578b", (Object[])new Object[0]);
            });
        }
    }

    @Override
    @Transactional
    public CarouselPictureEntity create(CarouselPictureDto dto) {
        this.createValidation(dto);
        CarouselPictureEntity entity = (CarouselPictureEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CarouselPictureEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        String tenant = TenantUtils.getTenantCode();
        entity.setTenantCode(tenant);
        this.carouselPictureRepository.save((Object)entity);
        this.carouselPictureScopeService.update(dto.getScopeList(), entity.getId());
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            CarouselPictureEventVo picEventVo = (CarouselPictureEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CarouselPictureEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(picEventListener -> picEventListener.onCreate(picEventVo));
        }
        return entity;
    }

    @Override
    @Transactional
    public CarouselPictureEntity update(CarouselPictureDto dto) {
        this.updateValidation(dto);
        CarouselPictureEntity entity = (CarouselPictureEntity)((Object)this.carouselPictureRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u56fe\u7247\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        CarouselPictureEntity newEntity = (CarouselPictureEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CarouselPictureEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.carouselPictureRepository.updateById((Object)newEntity);
        this.carouselPictureScopeService.update(dto.getScopeList(), newEntity.getId());
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            CarouselPictureEventVo oldVo = (CarouselPictureEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, CarouselPictureEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            CarouselPictureEventVo newVo = (CarouselPictureEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CarouselPictureEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(picEventListener -> picEventListener.onUpdate(oldVo, newVo));
        }
        return entity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.carouselPictureRepository.listByIds(ids);
        Validate.isTrue((CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.carouselPictureRepository.updateDelFlagByIds(ids);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, CarouselPictureEntity.class, CarouselPictureEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(picEventListener -> picEventListener.onDelete(voList));
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List entities = this.carouselPictureRepository.listByIds(ids);
        Validate.isTrue((CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u542f\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.carouselPictureRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, CarouselPictureEntity.class, CarouselPictureEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(picEventListener -> picEventListener.onEnable(voList));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.carouselPictureRepository.listByIds(ids);
        Validate.isTrue((CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u7981\u7528\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.carouselPictureRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (CollectionUtils.isNotEmpty(this.listeners)) {
            ArrayList voList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, CarouselPictureEntity.class, CarouselPictureEventVo.class, HashSet.class, ArrayList.class, new String[0]));
            this.listeners.forEach(picEventListener -> picEventListener.onDisable(voList));
        }
    }

    @Override
    public Page<CarouselPictureEntity> findByCarouselPictureCustomerPageDto(Pageable pageable, CarouselPictureCustomerPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CarouselPictureCustomerPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CarouselPictureCustomerPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        this.buildCustomerPageDto((AbstractCustomerPageDto)dto);
        ArrayList scopeCodeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getOrgCodeList())) {
            scopeCodeList.addAll(dto.getOrgCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCustomerCode())) {
            scopeCodeList.add(dto.getCustomerCode());
        }
        dto.setScopeCodeList((List)scopeCodeList);
        return this.carouselPictureRepository.findByCarouselPictureCustomerPageDto(pageable, dto);
    }
}

