/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.interaction.local.service.complaint.internal;

import com.biz.crm.dms.business.interaction.local.entity.complaint.ComplaintReplyFileEntity;
import com.biz.crm.dms.business.interaction.local.repository.complaint.ComplaintReplyFileRepository;
import com.biz.crm.dms.business.interaction.local.service.complaint.ComplaintReplyFileService;
import com.biz.crm.dms.business.interaction.sdk.dto.base.InteractionFileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="complaintReplyFileService")
public class ComplaintReplyFileServiceImpl
implements ComplaintReplyFileService {
    private static final Logger log = LoggerFactory.getLogger(ComplaintReplyFileServiceImpl.class);
    @Autowired(required=false)
    private ComplaintReplyFileRepository complaintReplyFileRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void create(List<InteractionFileDto> dtoList, String replyId) {
        Validate.notBlank((CharSequence)replyId, (String)"\u6295\u8bc9\u56de\u590dID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        String tenantCode = TenantUtils.getTenantCode();
        List entities = dtoList.stream().filter(Objects::nonNull).map(dto -> {
            ComplaintReplyFileEntity entity = (ComplaintReplyFileEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, ComplaintReplyFileEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setReplyId(replyId);
            entity.setTenantCode(tenantCode);
            entity.setSortNum(dtoList.indexOf(dto));
            entity.setFileCode(dto.getFileCode());
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.complaintReplyFileRepository.saveBatch(entities);
    }
}

